import sys
import math

######  Usage -- run from the command line as:      python3 ./getpi.py N_iterations

def gregory_leibniz_pi(niterations):
    """
	calculate Pi using Gregory-Leibniz series
	pi/4 = 1 - 1/3 + 1/5 - 1/7 + 1/9 ........
    """    
 
    print("iterations Pi_estimated  Pi_true")
 
    numerator = 1.
    denominator = 1.
    sum = 0.
   
    for i in range(niterations):
        sum += (numerator / denominator)
        numerator = numerator * -1.
        denominator += 2.
        estimated_pi = 4. * sum
##        print(i, estimated_pi, math.pi)
    print(i, estimated_pi, math.pi)

def main():
    if (len(sys.argv) != 2):
        print("usage:  sys.argv[0] n_iterations")
        sys.exit()

    n_iterations = int(sys.argv[1])

    gregory_leibniz_pi(n_iterations)


if __name__ == '__main__':
    main()        






